/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.entity;

import com.hollingsworth.mother_silverfish.Config;
import com.hollingsworth.mother_silverfish.entity.BabyFish;
import com.hollingsworth.mother_silverfish.entity.BabyPoisonFish;
import com.hollingsworth.mother_silverfish.entity.HealthStealFish;
import com.hollingsworth.mother_silverfish.entity.IAnimationListener;
import com.hollingsworth.mother_silverfish.entity.ItemStealFish;
import com.hollingsworth.mother_silverfish.entity.goals.ChargeGoal;
import com.hollingsworth.mother_silverfish.entity.goals.EarthquakeGoal;
import com.hollingsworth.mother_silverfish.entity.goals.HurtByPlayerGoal;
import com.hollingsworth.mother_silverfish.setup.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MotherSilverfishEntity
extends Monster
implements IAnimationListener,
IAnimatable {
    public static TagKey<Block> BREAK_WHITELIST = BlockTags.create((ResourceLocation)new ResourceLocation("mother_silverfish", "breakable"));
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true).m_7005_(true);
    public int earthquakeCooldown;
    public int spawnCooldown;
    public int chargeCooldown;
    public boolean isCharging;
    AnimationController attackController;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MotherSilverfishEntity(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_19793_ = 2.0f;
        this.m_21530_();
    }

    public void m_5618_(float pOffset) {
        this.f_20883_ = pOffset;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.spawnCooldown > 0) {
            --this.spawnCooldown;
        }
        if (this.earthquakeCooldown > 0) {
            --this.earthquakeCooldown;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (!this.f_19853_.f_46443_ && this.spawnCooldown <= 0 && this.m_5448_() != null) {
            BabyFish silverfish = this.getSpawn();
            this.f_19853_.m_7967_((Entity)silverfish);
            this.spawnCooldown = this.getSpawnCooldown();
        }
    }

    public float m_6113_() {
        return super.m_6113_();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.0f;
    }

    protected AABB m_142242_() {
        return super.m_142242_();
    }

    public BabyFish getSpawn() {
        double rand = this.f_19796_.nextDouble();
        BabyFish babyFish = rand < 0.33 ? new BabyPoisonFish(EntityRegistry.POISON_FISH, this.f_19853_) : (rand < 0.66 ? new HealthStealFish(EntityRegistry.HEALTH_STEAL_FISH, this.f_19853_) : new ItemStealFish(EntityRegistry.ITEM_STEAL_FISH, this.f_19853_));
        babyFish.m_6034_(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
        babyFish.motherID = this.m_142049_();
        if (this.m_5448_() != null) {
            babyFish.m_6710_(this.m_5448_());
        }
        return babyFish;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ChargeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new EarthquakeGoal(this, () -> this.earthquakeCooldown <= 0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, ((Double)Config.EASY_MOTHER_MOVE_SPEED.get()).doubleValue(), false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByPlayerGoal((PathfinderMob)this).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public int getEarthquakeCooldown() {
        return (Integer)Config.EASY_QUAKE_COOLDOWN.get();
    }

    public int getSpawnCooldown() {
        return (Integer)Config.EASY_SUMMON_BABY.get();
    }

    public int getChargeCooldown() {
        return (Integer)Config.EASY_CHARGE_COOLDOWN.get();
    }

    public boolean canCharge() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("charge", this.chargeCooldown);
        tag.m_128405_("spawn", this.spawnCooldown);
        tag.m_128405_("earthquake", this.earthquakeCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.chargeCooldown = tag.m_128451_("charge");
        this.spawnCooldown = tag.m_128451_("spawn");
        this.earthquakeCooldown = tag.m_128451_("earthquake");
    }

    public static AttributeSupplier.Builder attributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)Config.EASY_MOTHER_HEALTH.get()).doubleValue()).m_22268_(Attributes.f_22279_, ((Double)Config.EASY_MOTHER_MOVE_SPEED.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)Config.EASY_MOTHER_ATTACK_DAMAGE.get()).doubleValue()).m_22268_(Attributes.f_22285_, ((Double)Config.EASY_MOTHER_TOUGHNESS.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)Config.EASY_MOTHER_ARMOR.get()).doubleValue()).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22278_, ((Double)Config.EASY_MOTHER_KNOCKBACK_RESISTANCE.get()).doubleValue()).m_22268_(Attributes.f_22282_, ((Double)Config.EASY_MOTHER_ATTACK_KNOCKBACK.get()).doubleValue());
    }

    public double m_21133_(Attribute pAttribute) {
        return super.m_21133_(pAttribute);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    public int getCooldownModifier() {
        return 100;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        EntityDamageSource entityDamageSource;
        if (pSource == DamageSource.f_19308_ || pSource == DamageSource.f_19310_ || pSource == DamageSource.f_19312_) {
            return false;
        }
        if (pSource instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)pSource).m_7639_() instanceof FakePlayer) {
            return false;
        }
        if ((Integer)Config.MAX_DAMAGE_TAKEN.get() > 0) {
            return super.m_6469_(pSource, Math.min(pAmount, (float)((Integer)Config.MAX_DAMAGE_TAKEN.get()).intValue()));
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_20329_(Entity pEntity) {
        return false;
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        return false;
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof Silverfish) {
            return false;
        }
        return super.m_7327_(pEntity);
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (this.attackController == null) {
                return;
            }
            if (arg == Animations.CHARGE.ordinal()) {
                if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animationName.equals("charge")) {
                    return;
                }
                this.attackController.markNeedsReload();
                this.attackController.setAnimation(new AnimationBuilder().addAnimation("charge", Boolean.valueOf(false)).addAnimation("idle"));
            }
            if (arg == Animations.EARTHQUAKE.ordinal()) {
                if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animationName.equals("slam_master")) {
                    return;
                }
                this.attackController.markNeedsReload();
                this.attackController.setAnimation(new AnimationBuilder().addAnimation("slam_master", Boolean.valueOf(false)).addAnimation("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        super.m_7840_(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        this.f_19789_ = Math.min(this.f_19789_, 10.0f);
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.f_20891_ = 0;
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        this.bossEvent.m_6543_(p_184178_1_);
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.bossEvent.m_6539_(p_184203_1_);
    }

    public boolean m_6072_() {
        return false;
    }

    public PlayState crawlController(AnimationEvent arg) {
        Animation animation = arg.getController().getCurrentAnimation();
        if (arg.isMoving()) {
            if (animation != null && (animation.animationName.equals("slam_master") || animation.animationName.equals("charge"))) {
                return PlayState.STOP;
            }
            arg.getController().setAnimation(new AnimationBuilder().addAnimation("crawl", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "crawl", 1.0f, this::crawlController));
        this.attackController = new AnimationController((IAnimatable)this, "attackController", 1.0f, this::attackPredicate);
        data.addAnimationController(this.attackController);
    }

    private <T extends IAnimatable> PlayState attackPredicate(AnimationEvent<T> tAnimationEvent) {
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static enum Animations {
        CHARGE,
        EARTHQUAKE;

    }
}

